import java.awt.image.ImageObserver;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;
import java.awt.Color;

//
// Decompiled by Procyon v0.5.36
//

class Player extends Sprite
{
    static final int SPEED = 4;
    static final int REPEAT = 1;
    static final int FRAMES = 4;
    static final int XOFFSET = -7;
    static final int YOFFSET = -7;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    static final int UP = 3;
    static final int DOWN = 4;
    static final Color COL_DRAW;
    static final Color COL_LINE;
    static final Color COL_FILL;
    int KeyRepeat;
    boolean Key_L;
    boolean Key_R;
    boolean Key_U;
    boolean Key_D;
    int StartXPos;
    int StartYPos;
    int OldXPos;
    int OldYPos;
    int StartFrame;
    int Xoffs;
    int Yoffs;
    int Xmax;
    int Ymax;
    static int Destroyed;
    int dir;
    boolean Restart;
    boolean FillFlag;
    Vector Points;
    Vector AllPoints;
    Vector NewPoints;
    Vector ClearList;
    static Sprite Player;

    private boolean GetFrontier(final int n) {
        final Polygon polygon = new Polygon();
        final Vector<Point> vector = new Vector<Point>();
        final Point point = (Point) this.Points.elementAt(0);
        final Point point2 = (Point) this.Points.elementAt(1);
        int x = point.x;
        int y = point.y;
        if (point.x == point2.x) {
            x += n;
        }
        else {
            y += n;
        }
        int n2 = 0;
        boolean b = true;
        while (b) {
            Fillit.Matrix[x][y] = 3;
            vector.addElement(new Point(x, y));
            while (b) {
                if (Fillit.Matrix[x][y - 1] == 0 && this.Ok(x, y - 1)) {
                    if (n2 != 3) {
                        polygon.addPoint(x, y);
                    }
                    n2 = 3;
                    --y;
                    break;
                }
                if (Fillit.Matrix[x - 1][y] == 0 && this.Ok(x - 1, y)) {
                    if (n2 != 1) {
                        polygon.addPoint(x, y);
                    }
                    n2 = 1;
                    --x;
                    break;
                }
                if (Fillit.Matrix[x][y + 1] == 0 && this.Ok(x, y + 1)) {
                    if (n2 != 4) {
                        polygon.addPoint(x, y);
                    }
                    n2 = 4;
                    ++y;
                    break;
                }
                if (Fillit.Matrix[x + 1][y] == 0 && this.Ok(x + 1, y)) {
                    if (n2 != 2) {
                        polygon.addPoint(x, y);
                    }
                    n2 = 2;
                    ++x;
                    break;
                }
                b = false;
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            final Point point3 = vector.elementAt(i);
            Fillit.Matrix[point3.x][point3.y] = 0;
        }
        return !Fillit.EnemyInside(polygon);
    }

    private void GetAllPoints() {
        this.AllPoints.addElement(new Point(super.XPos, super.YPos));
    }

    private void PaintDot(final Graphics graphics, final int n, final int n2, final Color color) {
        this.SetColor(graphics, color);
        graphics.drawLine(n + this.Xoffs, n2 + this.Yoffs, n + this.Xoffs, n2 + this.Yoffs);
        Fillit.RescueGfx.drawLine(n + this.Xoffs, n2 + this.Yoffs, n + this.Xoffs, n2 + this.Yoffs);
    }

    private void DrawLine(final Graphics graphics, final int n, final int n2, final int n3, final int n4) {
        graphics.drawLine(n, n2, n3, n4);
        Fillit.RescueGfx.drawLine(n, n2, n3, n4);
    }

    public Player(final int xPos, final int yPos, final int xoffs, final int yoffs, final int xmax, final int ymax) {
        this.Points = new Vector();
        this.AllPoints = new Vector();
        this.NewPoints = new Vector();
        this.ClearList = new Vector();
        ((Player) Player).Player = this;
        super.Name = "Player";
        super.XPos = xPos;
        super.YPos = yPos;
        this.Xoffs = xoffs;
        this.Yoffs = yoffs;
        this.Xmax = xmax;
        this.Ymax = ymax;
        super.Priority = 1;
        super.FrameCount = 0;
        super.MaxFrames = 4;
        ((Player) Player).Destroyed = 0;
        this.dir = 0;
        this.KeyRepeat = 0;
        this.Restart = false;
        this.FillFlag = false;
        super.Visible = true;
        super.Frames = Fillit.Player_Frames;
    }

    public void Copy(final Graphics graphics) {
        if (((Player) Player).Destroyed != 0) {
            this.FillFlag = false;
            if ((((Player) Player).Destroyed & 0x1) == 0x0) {
                graphics.drawImage(super.Frames[super.FrameCount], super.XPos - 7 + this.Xoffs, super.YPos - 7 + this.Yoffs, null);
            }
            return;
        }
        if (this.FillFlag) {
            this.FillFlag = false;
            for (int i = 0; i < this.AllPoints.size(); ++i) {
                final Point point = (Point) this.AllPoints.elementAt(i);
                this.PaintDot(graphics, point.x, point.y, ((Player) Player).COL_LINE);
            }
            for (int j = 0; j < this.AllPoints.size(); ++j) {
                final Point point2 = (Point) this.AllPoints.elementAt(j);
                Fillit.Matrix[point2.x][point2.y] = 2;
            }
            if (this.GetFrontier(1)) {
                final int fill = this.Fill(this.SetFrontier(1), graphics);
                Fillit.Filled += fill;
                Fillit.Score += fill * 2 >> 4;
            }
            else if (this.GetFrontier(-1)) {
                final int fill2 = this.Fill(this.SetFrontier(-1), graphics);
                Fillit.Filled += fill2;
                Fillit.Score += fill2 * 2 >> 4;
            }
            this.Points.removeAllElements();
            this.AllPoints.removeAllElements();
        }
        if (this.Restart) {
            this.PlayerReset(graphics);
            return;
        }
        for (int k = 0; k < this.NewPoints.size(); ++k) {
            final Point point3 = (Point) this.NewPoints.elementAt(k);
            this.PaintDot(graphics, point3.x, point3.y, ((Player) Player).COL_DRAW);
        }
        this.NewPoints.removeAllElements();
        if (Fillit.Matrix[super.XPos][super.YPos] == 1 && Fillit.Matrix[this.OldXPos][this.OldYPos] == 2) {
            this.StartXPos = this.OldXPos;
            this.StartYPos = this.OldYPos;
            this.StartFrame = super.FrameCount;
        }
        if (Fillit.Matrix[super.XPos][super.YPos] == 2 && Fillit.Matrix[this.OldXPos][this.OldYPos] != 2) {
            this.FillFlag = true;
        }
        graphics.drawImage(super.Frames[super.FrameCount], super.XPos - 7 + this.Xoffs, super.YPos - 7 + this.Yoffs, null);
    }

    private int Fill(final Polygon polygon, final Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.SetColor(graphics, ((Player) Player).COL_FILL);
        int n4 = polygon.xpoints[0];
        int n5 = polygon.ypoints[0];
        int n6 = polygon.xpoints[0];
        int n7 = polygon.ypoints[0];
        for (int i = 0; i < polygon.npoints; ++i) {
            if (polygon.xpoints[i] < n4) {
                n4 = polygon.xpoints[i];
            }
            if (polygon.ypoints[i] < n5) {
                n5 = polygon.ypoints[i];
            }
            if (polygon.xpoints[i] > n6) {
                n6 = polygon.xpoints[i];
            }
            if (polygon.ypoints[i] > n7) {
                n7 = polygon.ypoints[i];
            }
        }
        final int n8 = n6 - n4 + 1;
        final int n9 = n7 - n5 + 1;
        int n10 = 0;
        int n11 = 0;
        for (int j = 0; j < n9; ++j) {
            int n12 = n4;
            final int y = n5;
            for (int k = 0; k < n8; ++k) {
                if (Fillit.Matrix[n12][y] == 4) {
                    if (n10 != 0) {
                        if (n11 != 0) {
                            if (Fillit.Matrix[n12 + 1][y] != 4 && !polygon.inside(n12 + 1, y)) {
                                n11 = 0;
                                n10 = 0;
                                this.DrawLine(graphics, n2 + this.Xoffs, n3 + this.Yoffs, n12 + this.Xoffs, y + this.Yoffs);
                            }
                            Fillit.Matrix[n12][y] = 3;
                            ++n;
                        }
                        else {
                            n10 = 0;
                            this.DrawLine(graphics, n2 + this.Xoffs, n3 + this.Yoffs, n12 + this.Xoffs, y + this.Yoffs);
                            Fillit.Matrix[n12][y] = 3;
                            ++n;
                        }
                    }
                    else {
                        n10 = 1;
                        n2 = n12;
                        n3 = y;
                        Fillit.Matrix[n12][y] = 3;
                        ++n;
                        if (Fillit.Matrix[n12 + 1][y] == 4) {
                            n11 = 1;
                        }
                    }
                }
                else if (n10 != 0) {
                    Fillit.Matrix[n12][y] = 3;
                    ++n;
                }
                ++n12;
            }
            ++n5;
        }
        return n;
    }

    private boolean Ok(final int n, final int n2) {
        return Fillit.Matrix[n + 1][n2] == 2 || Fillit.Matrix[n - 1][n2] == 2 || Fillit.Matrix[n][n2 + 1] == 2 || Fillit.Matrix[n][n2 - 1] == 2 || Fillit.Matrix[n + 1][n2 + 1] == 2 || Fillit.Matrix[n - 1][n2 - 1] == 2 || Fillit.Matrix[n + 1][n2 - 1] == 2 || Fillit.Matrix[n - 1][n2 + 1] == 2;
    }

    private void PlayerReset(final Graphics graphics) {
        this.Points.addElement(new Point(super.XPos, super.YPos));
        for (int i = 0; i < this.AllPoints.size(); ++i) {
            final Point point = (Point) this.AllPoints.elementAt(i);
            this.PaintDot(graphics, point.x, point.y, Color.black);
        }
        for (int j = 0; j < this.AllPoints.size(); ++j) {
            final Point point2 = (Point)  this.AllPoints.elementAt(j);
            Fillit.Matrix[point2.x][point2.y] = 0;
        }
        this.Points.removeAllElements();
        this.AllPoints.removeAllElements();
        this.NewPoints.removeAllElements();
        super.XPos = this.StartXPos;
        super.YPos = this.StartYPos;
        this.OldXPos = this.StartXPos;
        this.OldYPos = this.StartYPos;
        super.FrameCount = this.StartFrame;
        this.dir = 0;
        if (Fillit.Lives > 0L) {
            --Fillit.Lives;
        }
        this.KeyRepeat = 0;
        this.Key_L = false;
        this.Key_R = false;
        this.Key_U = false;
        this.Key_D = false;
        this.Restart = false;
    }

    private void SetColor(final Graphics graphics, final Color color) {
        graphics.setColor(color);
        Fillit.RescueGfx.setColor(color);
    }

    static {
        COL_DRAW = new Color(255, 128, 128);
        COL_LINE = new Color(128, 128, 255);
        COL_FILL = new Color(16, 32, 96);
    }

    private void GetNewPoints() {
        this.NewPoints.addElement(new Point(super.XPos, super.YPos));
    }

    private Polygon SetFrontier(final int n) {
        final Polygon polygon = new Polygon();
        final Point point = (Point)  this.Points.elementAt(0);
        final Point point2 = (Point)  this.Points.elementAt(1);
        int x = point.x;
        int y = point.y;
        if (point.x == point2.x) {
            x += n;
        }
        else {
            y += n;
        }
        int n2 = 0;
        boolean b = true;
        while (b) {
            Fillit.Matrix[x][y] = 4;
            while (b) {
                if (Fillit.Matrix[x][y - 1] == 0 && this.Ok(x, y - 1)) {
                    if (n2 != 3) {
                        polygon.addPoint(x, y);
                    }
                    n2 = 3;
                    --y;
                    break;
                }
                if (Fillit.Matrix[x - 1][y] == 0 && this.Ok(x - 1, y)) {
                    if (n2 != 1) {
                        polygon.addPoint(x, y);
                    }
                    n2 = 1;
                    --x;
                    break;
                }
                if (Fillit.Matrix[x][y + 1] == 0 && this.Ok(x, y + 1)) {
                    if (n2 != 4) {
                        polygon.addPoint(x, y);
                    }
                    n2 = 4;
                    ++y;
                    break;
                }
                if (Fillit.Matrix[x + 1][y] == 0 && this.Ok(x + 1, y)) {
                    if (n2 != 2) {
                        polygon.addPoint(x, y);
                    }
                    n2 = 2;
                    ++x;
                    break;
                }
                b = false;
            }
        }
        return polygon;
    }

    public boolean Handler() {
        if (Fillit.LevelComplete || Fillit.GameComplete || this.FillFlag) {
            return true;
        }
        if (((Player) Player).Destroyed > 0) {
            if (--((Player) Player).Destroyed == 0) {
                this.Restart = true;
            }
            return true;
        }
        if (this.KeyRepeat == 0) {
            this.Key_L = Fillit.Key_L;
            this.Key_R = Fillit.Key_R;
            this.Key_U = Fillit.Key_U;
            this.Key_D = Fillit.Key_D;
        }
        this.OldXPos = super.XPos;
        this.OldYPos = super.YPos;
        if (Fillit.KeyDownCode == 32) {
            Fillit.KeyDownCode = 0;
        }
        int n = 0;
        do {
            if (this.Key_L) {
                super.FrameCount = 3;
                if (this.dir != 1) {
                    if (Fillit.Matrix[super.XPos][super.YPos] != 2) {
                        this.GetNewLine();
                        this.dir = 1;
                    }
                    else {
                        this.dir = 0;
                    }
                }
                if (super.XPos > 0) {
                    if (Fillit.Matrix[super.XPos - 1][super.YPos] == 1) {
                        ((Player) Player).Destroyed = 100;
                    }
                    else if (Fillit.Matrix[super.XPos - 1][super.YPos] == 0) {
                        --super.XPos;
                        this.GetAllPoints();
                    }
                    else if (Fillit.Matrix[super.XPos][super.YPos] == 1 && Fillit.Matrix[super.XPos - 1][super.YPos] == 2) {
                        this.GetNewLine();
                        --super.XPos;
                        this.dir = 0;
                    }
                    else if (Fillit.Matrix[super.XPos - 1][super.YPos] == 2) {
                        --super.XPos;
                    }
                }
            }
            else if (this.Key_R) {
                super.FrameCount = 1;
                if (this.dir != 2) {
                    if (Fillit.Matrix[super.XPos][super.YPos] != 2) {
                        this.GetNewLine();
                        this.dir = 2;
                    }
                    else {
                        this.dir = 0;
                    }
                }
                if (super.XPos < this.Xmax - 1) {
                    if (Fillit.Matrix[super.XPos + 1][super.YPos] == 1) {
                        ((Player) Player).Destroyed = 100;
                    }
                    else if (Fillit.Matrix[super.XPos + 1][super.YPos] == 0) {
                        ++super.XPos;
                        this.GetAllPoints();
                    }
                    else if (Fillit.Matrix[super.XPos][super.YPos] == 1 && Fillit.Matrix[super.XPos + 1][super.YPos] == 2) {
                        this.GetNewLine();
                        ++super.XPos;
                        this.dir = 0;
                    }
                    else if (Fillit.Matrix[super.XPos + 1][super.YPos] == 2) {
                        ++super.XPos;
                    }
                }
            }
            else if (this.Key_U) {
                super.FrameCount = 0;
                if (this.dir != 3) {
                    if (Fillit.Matrix[super.XPos][super.YPos] != 2) {
                        this.GetNewLine();
                        this.dir = 3;
                    }
                    else {
                        this.dir = 0;
                    }
                }
                if (super.YPos > 0) {
                    if (Fillit.Matrix[super.XPos][super.YPos - 1] == 1) {
                        ((Player) Player).Destroyed = 100;
                    }
                    else if (Fillit.Matrix[super.XPos][super.YPos - 1] == 0) {
                        --super.YPos;
                        this.GetAllPoints();
                    }
                    else if (Fillit.Matrix[super.XPos][super.YPos] == 1 && Fillit.Matrix[super.XPos][super.YPos - 1] == 2) {
                        this.GetNewLine();
                        --super.YPos;
                        this.dir = 0;
                    }
                    else if (Fillit.Matrix[super.XPos][super.YPos - 1] == 2) {
                        --super.YPos;
                    }
                }
            }
            else if (this.Key_D) {
                super.FrameCount = 2;
                if (this.dir != 4) {
                    if (Fillit.Matrix[super.XPos][super.YPos] != 2) {
                        this.GetNewLine();
                        this.dir = 4;
                    }
                    else {
                        this.dir = 0;
                    }
                }
                if (super.YPos < this.Ymax - 1) {
                    if (Fillit.Matrix[super.XPos][super.YPos + 1] == 1) {
                        ((Player) Player).Destroyed = 100;
                    }
                    else if (Fillit.Matrix[super.XPos][super.YPos + 1] == 0) {
                        ++super.YPos;
                        this.GetAllPoints();
                    }
                    else if (Fillit.Matrix[super.XPos][super.YPos] == 1 && Fillit.Matrix[super.XPos][super.YPos + 1] == 2) {
                        this.GetNewLine();
                        ++super.YPos;
                        this.dir = 0;
                    }
                    else if (Fillit.Matrix[super.XPos][super.YPos + 1] == 2) {
                        ++super.YPos;
                    }
                }
            }
            if (Fillit.Matrix[super.XPos][super.YPos] == 0) {
                Fillit.Matrix[super.XPos][super.YPos] = 1;
                this.GetNewPoints();
            }
        } while (++n < 4);
        if (this.KeyRepeat++ == 1) {
            this.KeyRepeat = 0;
        }
        if (Fillit.Lives == 0L) {
            Fillit.OverCounter = 200;
            return false;
        }
        return true;
    }

    private void GetNewLine() {
        this.Points.addElement(new Point(super.XPos, super.YPos));
    }
}
